﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using CashierCrisis.Behaviors;
using CashierCrisis.Core;

namespace CashierCrisis.Entities
{
   

    public class BrainComponent : Component
    {
        public bool Finished = true;

        public BrainComponent(string name)
            : base(name)
        {

        }

        public BehaviorDelegateFinished BehaviorFinished;
        public void OnBehaviorFinished(Status status)
        {
            if (BehaviorFinished != null)
                BehaviorFinished(status);
            Finished = true;
        }

        private List<IVisitor> visitors = new List<IVisitor>();
        
        private Behavior node;

        public override void Update(Microsoft.Xna.Framework.GameTime gameTime)
        {
            if (node == null)
                return;

            Status status = node.Execute(gameTime);

            if (status == Status.Completed || status == Status.Failed)
            {
                OnBehaviorFinished(status);
            }
        }

        public void Add(Behavior node)
        {
            if (node == null)
            {
                return;
            }

            for (int i = 0; i < visitors.Count; i++)
            {
                visitors[i].Visit(node);
            }

            this.node = node;
        }

        public void AddVisitor(IVisitor behaviorVisitor)
        {
            visitors.Add(behaviorVisitor);
        }
    }
}
